define(['angular', 'angularMocks', 'LandingController', 'angularUiBootstrap'], function(angular, mocks) {
    'use strict';

    describe("The landing controller", function (){
        var controller,
            scope,
            focusServiceMock,
			pageServiceMock,
            globalDelayTrackerMock,
			landingServiceMock,
            formatterMock,
            mhpuserMock = {
                firstName: "One",
                lastName: "Provider",
                facilityName: "Boston"
            },
            config = function () {
							app: "VA Tool Set"
						};

        beforeEach( function () {
            module('angularTemplateApp');

            focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain']);
            pageServiceMock = jasmine.createSpyObj('pageService', ['redirectToLaunchpad']);
			landingServiceMock = jasmine.createSpyObj('landingService', ['toolSetItems']);
            formatterMock = jasmine.createSpyObj('formatter', ['toDashCase']);
            globalDelayTrackerMock = jasmine.createSpyObj('globalDelayTracker', ['active']);
            globalDelayTrackerMock.active.andCallFake(function(){
                return true;
            });

			module(function($provide){
                $provide.value('focusService', focusServiceMock);
                $provide.value('pageService', pageServiceMock);
                $provide.value('globalDelayTracker', globalDelayTrackerMock);
				$provide.value('landingService', landingServiceMock);
                $provide.value('formatter', formatterMock);
			});

            inject(function($controller, $rootScope, formatter) {
                scope = $rootScope.$new();
                controller = $controller('LandingController', {$scope:scope, mhpuser: mhpuserMock});
            });

        });

        it ("should provide a name", function() {
          expect(scope.userFirstLastName).toBe("One Provider");
        });

        it ("should provide a date", function() {
          expect(typeof(scope.today)).toEqual('object')
        });

    });
});
